#!/bin/sh

MASTER_PAGE_ESXI_INFO_CONF_RESULT_MSG=""
MASTER_PAGE_ESXI_INFO_CONF_RESULT_OK=0
MASTER_PAGE_ESXI_INFO_CONF_RESULT_ERROR=1

MASTER_PAGE_ESXI_INFO_CONF_RESULT_CODE=${MASTER_PAGE_ESXI_INFO_CONF_RESULT_ERROR}
MASTER_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0


master_page_esxi_info_conf() {
	debug_print "in function '${FUNCNAME[0]}'"
	
    # assign default value
    [ -z "${RT_ESXI_IP}" ]       && RT_ESXI_IP="${conf_esxi_ip}"
    [ -z "${RT_ESXI_USERNAME}" ] && RT_ESXI_USERNAME="${conf_esxi_username}"
    [ -z "${RT_ESXI_PASSWORD}" ] && RT_ESXI_PASSWORD="${conf_esxi_password}"
    
    
	tp_username_password \
		"${MASTER_PAGE_ESXI_INFO_CONF_TITLE}" \
		"${MASTER_PAGE_ESXI_INFO_CONF_TEXT}" \
		"${MASTER_PAGE_ESXI_INFO_CONF_LABEL_OK}" \
		"${MASTER_PAGE_ESXI_INFO_CONF_LABEL_CANCEL}" \
        "${RT_ESXI_USERNAME}" \
        "${RT_ESXI_PASSWORD}"
        
        
    debug_print "TP_USERNAME_PASSWORD_RESULT_CODE: ${TP_USERNAME_PASSWORD_RESULT_CODE}"
    case "${TP_USERNAME_PASSWORD_RESULT_CODE}" in
    
        "${TP_USERNAME_PASSWORD_RESULT_ERROR}")
            MASTER_PAGE_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_CONF_RESULT_ERROR
            MASTER_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
            MASTER_PAGE_ESXI_INFO_CONF_RESULT_MSG="${TP_USERNAME_PASSWORD_RESULT_MSG}"
            return
            ;;
        
        "${TP_USERNAME_PASSWORD_RESULT_CANCEL}")
            MASTER_PAGE_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_CONF_RESULT_OK
            MASTER_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=-1
            MASTER_PAGE_ESXI_INFO_CONF_RESULT_MSG=""
            return
            ;;
            
        "${TP_USERNAME_PASSWORD_RESULT_OK}" )
            ;;
        
        *)
            MASTER_PAGE_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_CONF_RESULT_ERROR
            MASTER_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
            MASTER_PAGE_ESXI_INFO_CONF_RESULT_MSG="${MASTER_PAGE_ESXI_INFO_CONF_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    # check esxi connection
    local ret
    local msg
    msg=`/usr/bin/esxcli \
        --server   "${RT_ESXI_IP}" \
        --username "${TP_USERNAME_PASSWORD_RESULT_USERNAME}" \
        --password "${TP_USERNAME_PASSWORD_RESULT_PASSWORD}"`
    ret="${?}"
    if [ "${ret}" -eq 2 -o "${ret}" -eq 130 ]; then
        debug_print "TerminateByCtrlC: ret='${ret}'"
        
        MASTER_PAGE_ESXI_INFO_CONF_RESULT_CODE="${MASTER_PAGE_ESXI_INFO_CONF_RESULT_OK}"
		MASTER_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
        MASTER_PAGE_ESXI_INFO_CONF_RESULT_MSG=""
        return
    
    elif [ "${ret}" -ne 0 ]; then
        MASTER_PAGE_ESXI_INFO_CONF_RESULT_CODE="${MASTER_PAGE_ESXI_INFO_CONF_RESULT_ERROR}"
		MASTER_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
        MASTER_PAGE_ESXI_INFO_CONF_RESULT_MSG="${ERROR_ESXI_WRONG_USERNAME_PASSWORD}"
        return
    fi
    
    # save and error handling
    utility_save_esxi_conf \
        "${RT_ESXI_IP}" \
        "${TP_USERNAME_PASSWORD_RESULT_USERNAME}" \
        "${TP_USERNAME_PASSWORD_RESULT_PASSWORD}"
    if [ "${?}" -ne 0 ]; then
        MASTER_PAGE_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_CONF_RESULT_ERROR
        MASTER_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
        MASTER_PAGE_ESXI_INFO_CONF_RESULT_MSG="${MASTER_PAGE_ESXI_INFO_CONF_ERROR_SAVE_CONFIGURATION}: ${UTILITY_SAVE_ESXI_CONF_RESULT_MSG}"
        return
    fi
    
    # update to local usbx
    utility_save_esxi_conf_to_usbx
    if [ "${?}" -ne 0 ]; then
        MASTER_PAGE_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_CONF_RESULT_ERROR
        MASTER_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=0
        MASTER_PAGE_ESXI_INFO_CONF_RESULT_MSG="${MASTER_PAGE_ESXI_INFO_CONF_ERROR_SAVE_CONFIGURATION}: ${UTILITY_SAVE_ESXI_CONF_TO_USBX_RESULT_MSG}"
        return
    fi

    
    # apply successfully
    RT_ESXI_USERNAME="${TP_USERNAME_PASSWORD_RESULT_USERNAME}"
    RT_ESXI_PASSWORD="${TP_USERNAME_PASSWORD_RESULT_PASSWORD}"
    
    MASTER_PAGE_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_CONF_RESULT_OK
    MASTER_PAGE_ESXI_INFO_CONF_RESULT_ROLLING=1
    MASTER_PAGE_ESXI_INFO_CONF_RESULT_MSG=""
}
